/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.standard;

import CH.ifa.draw.figures.PolyLineFigure;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureSelection;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.framework.Painter;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.standard.FigureDrawInfo;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.standard.StandardDrawingView;
import DE.siemens.ad.logo.app.Editor;
import DE.siemens.ad.logo.app.Model;
import DE.siemens.ad.logo.app.View;
import DE.siemens.ad.logo.app.action.ActionManager;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.OutBlockConnectorEnumeration;
import DE.siemens.ad.logo.model.ParameterInBlockConnector;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.ParameterItemList;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.logo.util.ScalableMouseEvent;
import DE.siemens.ad.logo.util.ValueOrItemReference;
import DE.siemens.ad.pdraw.action.DeleteFiguresAction;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.app.LogoFigureSelection;
import DE.siemens.ad.pdraw.app.ZoomManager;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.figures.BlockIfcFigure;
import DE.siemens.ad.pdraw.figures.CutConnectFigure;
import DE.siemens.ad.pdraw.figures.FixedElbowConnection;
import DE.siemens.ad.pdraw.figures.InputIfcFigure;
import DE.siemens.ad.pdraw.figures.OutputIfcFigure;
import DE.siemens.ad.pdraw.figures.constraints.ConnectionLineConstraint;
import DE.siemens.ad.pdraw.figures.constraints.ConnectorConstraint;
import DE.siemens.ad.pdraw.figures.constraints.FigureConstraint;
import DE.siemens.ad.pdraw.figures.constraints.MultiHeadConstraint;
import DE.siemens.ad.pdraw.standard.FupFigureDrawInfo;
import DE.siemens.ad.pdraw.standard.LogoAbstractTool;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoGridConstrainer;
import DE.siemens.ad.pdraw.util.GridInfo;
import DE.siemens.ad.pdraw.util.SelectionPainter;
import DE.siemens.ad.udf.UDFBlockFigure;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Observable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class LogoDrawingView
extends StandardDrawingView
implements View {
    protected ZoomManager zoomManager;
    protected JScrollPane fScrollPane;
    protected boolean fSimulationUpdate;
    protected JComponent fViewComponent;
    protected FupFigureDrawInfo fScreenDrawInfo;
    protected boolean fSelectionMarking = false;
    protected GridInfo fGridInfo;
    private transient SelectionPainter fSelectionPainter;

    private void readObject(ObjectInputStream s) {
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        System.out.println("LogoDrawingView.writeObject()");
    }

    public LogoDrawingView(DrawingEditor editor, int width, int height) {
        super(editor, width, height);
        this.setLayout(null);
        ((Editor)((Object)editor)).addView(this);
        this.setToolTipText("tooltip");
        this.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        AbstractAction dummyAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
            }
        };
        this.getInputMap().put(KeyStroke.getKeyStroke(40, 0), dummyAction);
        this.getActionMap().put(dummyAction, dummyAction);
        this.getInputMap().put(KeyStroke.getKeyStroke(38, 0), dummyAction);
        this.getInputMap().put(KeyStroke.getKeyStroke(37, 0), dummyAction);
        this.getInputMap().put(KeyStroke.getKeyStroke(39, 0), dummyAction);
        this.addMouseWheelListener(new MouseWheelZoomer());
        new DropTarget(this, new DrawingDropTargetHandler());
        this.setAutoscrolls(true);
    }

    public void finalize() {
    }

    public Handle findHandle(int x, int y) {
        Enumeration k = this.selectionHandles();
        while (k.hasMoreElements()) {
            Handle handle = (Handle)k.nextElement();
            if (!handle.containsPoint(x, y) || handle instanceof NullHandle) continue;
            return handle;
        }
        return null;
    }

    public Object clone() {
        LogoDrawingView newView = new LogoDrawingView((LogoComfort)this.getEditor(), this.getWidth(), this.getHeight());
        newView.setDrawing(this.drawing());
        newView.setConstrainer(new LogoGridConstrainer(new GridInfo(newView)));
        Enumeration e = this.getBackgrounds().elements();
        while (e.hasMoreElements()) {
            newView.addBackground((Painter)e.nextElement());
        }
        return newView;
    }

    public synchronized void checkDamage() {
        super.checkDamage();
        this.getSelectionPainter().getDrawing().checkDamage();
    }

    public void drawDrawing(Graphics g) {
        if (this.getZoomManager().getZoom() != 100) {
            double zoomFactor = (double)this.getZoomManager().getZoom() / 100.0;
            Graphics2D graphics2D = (Graphics2D)g;
            Object antialiasing = LogoProperties.instance().getBooleanProperty("drawing.antialiasing", false) ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialiasing);
            graphics2D.scale(zoomFactor, zoomFactor);
            ((LogoDrawing)this.drawing()).draw(g, this.getScreenDrawInfo());
            graphics2D.scale(1.0 / zoomFactor, 1.0 / zoomFactor);
        } else {
            ((LogoDrawing)this.drawing()).draw(g, this.getScreenDrawInfo());
        }
    }

    public void drawHandles(Graphics g) {
        if (this.getZoomManager().getZoom() != 100) {
            double zoomFactor = (double)this.getZoomManager().getZoom() / 100.0;
            ((Graphics2D)g).scale(zoomFactor, zoomFactor);
            super.drawHandles(g);
            ((Graphics2D)g).scale(1.0 / zoomFactor, 1.0 / zoomFactor);
        } else {
            super.drawHandles(g);
        }
    }

    public void drawSelection(Graphics g) {
        Enumeration selection = this.selection().elements();
        while (selection.hasMoreElements()) {
            ((Figure)selection.nextElement()).draw(g);
        }
    }

    public void drawSimulation(Graphics g, boolean showSignalStates, boolean showParameterValues) {
        Graphics2D graphics = (Graphics2D)g.create();
        if (this.getZoomManager().getZoom() != 100) {
            double zoomFactor = (double)this.getZoomManager().getZoom() / 100.0;
            graphics.scale(zoomFactor, zoomFactor);
            ((LogoDrawing)this.drawing()).drawSimulation(graphics, showSignalStates, showParameterValues);
        } else {
            ((LogoDrawing)this.drawing()).drawSimulation(graphics, showSignalStates, showParameterValues);
        }
        graphics.dispose();
    }

    public Editor getEditor() {
        return (Editor)((Object)this.editor());
    }

    public GridInfo getGridInfo() {
        if (this.fGridInfo == null) {
            this.setGridInfo(new GridInfo(this));
        }
        return this.fGridInfo;
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void addToSelection(Figure figure) {
        if (figure.isSelectable()) {
            super.addToSelection(figure);
        }
    }

    public void addToSelection(FigureConstraint constraint) {
        if (constraint.getFigure() != null) {
            super.addToSelection(constraint.getFigure());
        } else if (constraint instanceof MultiHeadConstraint) {
            Vector figures = new Vector();
            ((MultiHeadConstraint)constraint).getFigures(figures);
            Iterator figuresIterator = figures.iterator();
            while (figuresIterator.hasNext()) {
                this.addToSelection((Figure)figuresIterator.next());
            }
        }
    }

    public Dimension getMinimumSize() {
        double zoomFactor = (double)this.getZoomManager().getZoom() / 100.0;
        return new Dimension((int)(this.getViewSize100().getWidth() * zoomFactor), (int)(this.getViewSize100().getHeight() * zoomFactor));
    }

    public Model getModel() {
        return (Model)((Object)this.drawing());
    }

    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        preferredSize.width = Math.max(50, preferredSize.width);
        preferredSize.height = Math.max(50, preferredSize.height);
        return preferredSize;
    }

    public FigureDrawInfo getScreenDrawInfo() {
        if (this.fScreenDrawInfo == null) {
            this.fScreenDrawInfo = new FupFigureDrawInfo();
        }
        this.fScreenDrawInfo.init();
        return this.fScreenDrawInfo;
    }

    public Dimension getSnapVector(Figure f) {
        return this.getSnapVector(f, 0, 0);
    }

    public Dimension getSnapVector(Figure f, int dx, int dy) {
        if (null == this.fGridInfo) {
            return new Dimension(0, 0);
        }
        Point p1 = new Point();
        if (f instanceof BlockFigure) {
            if (!this.fGridInfo.gridAttractionIsOn()) {
                return new Dimension(0, 0);
            }
            p1 = ((BlockFigure)f).getAlignmentAnchorGrid();
        } else if (f instanceof FixedElbowConnection) {
            if (!this.fGridInfo.gridConnectionAttractionIsOn()) {
                return new Dimension(0, 0);
            }
            int limitX = Math.min(((FixedElbowConnection)f).startPoint().x, ((FixedElbowConnection)f).endPoint().x);
            int limitY = Math.min(((FixedElbowConnection)f).startPoint().y, ((FixedElbowConnection)f).endPoint().y);
            int p1x = ((FixedElbowConnection)f).getAlignmentAnchor().x < limitX ? ((FixedElbowConnection)f).getAlignmentAnchor().x : limitX + dx - ((FixedElbowConnection)f).getAlignmentAnchor().x % this.getConstrainer().getStepX();
            int p1y = ((FixedElbowConnection)f).getAlignmentAnchor().y + 2 < limitY ? ((FixedElbowConnection)f).getAlignmentAnchor().y + 2 : limitY + dy - ((FixedElbowConnection)f).getAlignmentAnchor().y % this.getConstrainer().getStepY() - 2;
            p1.setLocation(p1x, p1y);
        }
        Point p2 = null != this.getConstrainer() ? this.getConstrainer().constrainPoint(p1) : p1;
        Dimension moveVector = new Dimension(p2.x - p1.x, p2.y - p1.y);
        return moveVector;
    }

    public String getToolTipText(MouseEvent event) {
        ScalableMouseEvent sme = new ScalableMouseEvent(event, this.getZoomManager().getZoom());
        Figure figure = this.drawing().findFigure(sme.getX(), sme.getY());
        if (figure instanceof CutConnectFigure) {
            return ((CutConnectFigure)figure).getTooltip((LogoDrawing)this.drawing());
        }
        if (figure instanceof BlockFigure) {
            return ((BlockFigure)figure).getBlock().getToolTipText();
        }
        figure = this.drawing().findFigureInside(sme.getX(), sme.getY());
        if (figure instanceof InputIfcFigure) {
            return ((InBlockConnector)((InputIfcFigure)figure).getBlockConnector()).getName();
        }
        if (figure instanceof OutputIfcFigure && figure.container() instanceof UDFBlockFigure) {
            return ((OutBlockConnector)((OutputIfcFigure)figure).getBlockConnector()).getName();
        }
        return null;
    }

    public JComponent getViewComponent() {
        if (this.fViewComponent == null) {
            JPanel centerPanel = new JPanel(new GridBagLayout());
            centerPanel.setBackground(centerPanel.getBackground().darker());
            centerPanel.setAutoscrolls(true);
            centerPanel.add(this);
            JScrollPane scrollPane = new JScrollPane(centerPanel);
            scrollPane.getVerticalScrollBar().setUnitIncrement(5);
            scrollPane.getHorizontalScrollBar().setUnitIncrement(5);
            this.fViewComponent = scrollPane;
        }
        return this.fViewComponent;
    }

    public Dimension getViewSize100() {
        return ((LogoDrawing)this.drawing()).getViewSize100();
    }

    public ZoomManager getZoomManager() {
        if (this.zoomManager == null) {
            this.zoomManager = new ZoomManager(this);
        }
        return this.zoomManager;
    }

    public boolean isSelectionMarking() {
        return this.fSelectionMarking;
    }

    public boolean isSimulationUpdate() {
        return this.fSimulationUpdate;
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 8 || code == 127) {
            Vector v = this.selection();
            if (v == null || v.isEmpty()) {
                return;
            }
            ActionManager actionManager = ((Editor)((Object)this.editor())).getActionManager();
            DeleteFiguresAction deleteAction = (DeleteFiguresAction)actionManager.getActionFactory().getAction("DeleteFiguresAction");
            actionManager.invokeAction(deleteAction);
        } else {
            super.keyPressed(e);
        }
    }

    public void mouseClicked(MouseEvent e) {
        e = new ScalableMouseEvent(e, this.getZoomManager().getZoom());
        super.mouseClicked(e);
    }

    public void mouseDragged(MouseEvent e) {
        e = new ScalableMouseEvent(e, this.getZoomManager().getZoom());
        super.mouseDragged(e);
    }

    public void mouseEntered(MouseEvent e) {
        e = new ScalableMouseEvent(e, this.getZoomManager().getZoom());
        super.mouseEntered(e);
    }

    public void mouseExited(MouseEvent e) {
        e = new ScalableMouseEvent(e, this.getZoomManager().getZoom());
        super.mouseExited(e);
    }

    public void mouseMoved(MouseEvent e) {
        e = new ScalableMouseEvent(e, this.getZoomManager().getZoom());
        super.mouseMoved(e);
    }

    public void mousePressed(MouseEvent e) {
        e = new ScalableMouseEvent(e, this.getZoomManager().getZoom());
        ((LogoComfort)this.editor()).setActiveView(this);
        super.mousePressed(e);
    }

    public void mouseReleased(MouseEvent e) {
        ScalableMouseEvent scaledEvent = new ScalableMouseEvent(e, this.getZoomManager().getZoom());
        if (SwingUtilities.isRightMouseButton(e)) {
            Cloneable clickedObject = this.drawing().findFigure(((MouseEvent)scaledEvent).getX(), ((MouseEvent)scaledEvent).getY());
            if (clickedObject == null) {
                clickedObject = this.drawing().findFigureInside(((MouseEvent)scaledEvent).getX(), ((MouseEvent)scaledEvent).getY());
            }
            if (clickedObject == null) {
                clickedObject = this;
                if (!e.isControlDown() && !this.selection().contains(clickedObject)) {
                    this.clearSelection();
                    this.checkDamage();
                }
            } else {
                if (!e.isControlDown() && !this.selection().contains(clickedObject)) {
                    this.clearSelection();
                }
                this.addToSelection((Figure)clickedObject);
                this.checkDamage();
            }
            if (this.selectionCount() > 1) {
                clickedObject = this.selection();
            }
            JPopupMenu popupMenu = ((LogoComfort)this.editor()).getMenuManager().getPopupMenu(clickedObject);
            popupMenu.show(this, e.getX(), e.getY());
        }
        e = new ScalableMouseEvent(e, this.getZoomManager().getZoom());
        super.mouseReleased(e);
    }

    public void repaint() {
        Rectangle r = this.getVisibleRect();
        this.repaint(r);
    }

    public void scrollToFigure(Figure figure) {
        JViewport viewport = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, this);
        if (viewport == null) {
            return;
        }
        Rectangle displayBox = figure.displayBox();
        double zoomFaktor = (double)this.getZoomManager().getZoom() / 100.0;
        displayBox.x = (int)((double)displayBox.x * zoomFaktor);
        displayBox.y = (int)((double)displayBox.y * zoomFaktor);
        displayBox.width = (int)((double)displayBox.width * zoomFaktor);
        displayBox.height = (int)((double)displayBox.height * zoomFaktor);
        Dimension viewportSize = viewport.getSize();
        displayBox.grow(viewportSize.width / 2, viewportSize.height / 2);
        this.scrollRectToVisible(displayBox);
    }

    public void setGridInfo(GridInfo newGridInfo) {
        this.fGridInfo = newGridInfo;
        if (this.fGridInfo.gridAttractionIsOn() || this.fGridInfo.gridConnectionAttractionIsOn()) {
            this.setConstrainer(new LogoGridConstrainer(this.fGridInfo));
            this.repaint();
        } else {
            this.setConstrainer(null);
        }
    }

    public void setSimulationUpdate(boolean newSimulationUpdate) {
        this.fSimulationUpdate = newSimulationUpdate;
    }

    public void update(Observable sender, Object arg) {
        double zoomFactor = (double)this.getZoomManager().getZoom() / 100.0;
        if (sender == this.drawing() || sender == this.getSelectionPainter().getDrawing()) {
            String argString;
            if (arg == null || arg instanceof Rectangle) {
                Rectangle r = (Rectangle)arg;
                if (r == null) {
                    this.setSimulationUpdate(true);
                    r = this.getVisibleRect();
                    this.repaint(r.x, r.y, r.width, r.height);
                    return;
                }
                this.setSimulationUpdate(false);
                r = new Rectangle((int)((double)r.x * zoomFactor), (int)((double)r.y * zoomFactor), (int)((double)r.width * zoomFactor), (int)((double)r.height * zoomFactor));
                this.repaint(r.x, r.y, r.width, r.height);
            } else if (arg instanceof String && (argString = (String)arg) == "drawingSizeChanged") {
                this.getViewComponent().invalidate();
                this.revalidate();
                this.repaint();
            }
        }
    }

    public FigureSelection getFigureSelection() {
        LogoFigureSelection selection = new LogoFigureSelection(this.selectionZOrdered());
        selection.setType(((LogoDrawing)this.drawing()).getWiringDiagram().getProgrammingLanguage().getName());
        return selection;
    }

    public Point getToolTipLocation(MouseEvent event) {
        String toolTipText = this.getToolTipText(event);
        if (toolTipText == null || toolTipText.equals("")) {
            return null;
        }
        Point result = null;
        result = event.getComponent().getCursor().getType() == -1 ? new Point(event.getX(), event.getY() + 40) : super.getToolTipLocation(event);
        return result;
    }

    public void setModel(Model model) {
        if (!(model instanceof LogoDrawing)) {
            throw new IllegalArgumentException("Only a LogoDrawing can be used as a model for a LogodrawingView.");
        }
        this.setDrawing((LogoDrawing)model);
    }

    protected void figureSelected(Figure figure) {
        if (this.fSelectionMarking) {
            SelectionPainter selectionPainter = this.getSelectionPainter();
            if (figure instanceof BlockFigure) {
                ArrayList ifcFigures = ((BlockFigure)figure).getInputIfcFigures();
                Iterator iterator = ifcFigures.iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    BlockIfcFigure element = (BlockIfcFigure)iterator.next();
                    if (element.getBlockConnector() instanceof ParameterInBlockConnector) continue;
                    for (ConnectionLineConstraint connectionConstraint : ((ConnectorConstraint)element.getConstraint()).getConnectionLineConstraints()) {
                        PolyLineFigure polyLineFigure = (PolyLineFigure)connectionConstraint.getFigure();
                        selectionPainter.add(polyLineFigure, i);
                    }
                    ++i;
                }
                ifcFigures = ((BlockFigure)figure).getOutputIfcFigures();
                for (BlockIfcFigure element : ifcFigures) {
                    for (ConnectionLineConstraint connectionConstraint : ((ConnectorConstraint)element.getConstraint()).getConnectionLineConstraints()) {
                        selectionPainter.add((PolyLineFigure)connectionConstraint.getFigure(), i);
                    }
                    ++i;
                }
                this.markerReferedFigure((BlockFigure)figure, 3);
            } else if (figure instanceof PolyLineFigure) {
                this.getSelectionPainter().add((PolyLineFigure)figure, 0);
            }
        }
    }

    private SelectionPainter getSelectionPainter() {
        if (this.fSelectionPainter == null) {
            this.fSelectionPainter = new SelectionPainter(this);
            this.addForeground(this.fSelectionPainter);
        }
        return this.fSelectionPainter;
    }

    protected void figureDeselected(Figure figure) {
        if (this.fSelectionMarking) {
            SelectionPainter selectionPainter = this.getSelectionPainter();
            LogoDrawing logoDrawing = (LogoDrawing)this.drawing();
            if (figure instanceof BlockFigure) {
                ArrayList ifcFigures = ((BlockFigure)figure).getInputIfcFigures();
                for (BlockIfcFigure element : ifcFigures) {
                    selectionPainter.remove(element);
                    for (ConnectionLineConstraint connectionConstraint : ((ConnectorConstraint)element.getConstraint()).getConnectionLineConstraints()) {
                        selectionPainter.remove((PolyLineFigure)connectionConstraint.getFigure());
                    }
                    InBlockConnector blockConnector = (InBlockConnector)element.getBlockConnector();
                    OutBlockConnectorEnumeration linkedConnectors = blockConnector.getLinkedConnectors();
                    while (linkedConnectors.hasMoreElements()) {
                        OutBlockConnector connector = linkedConnectors.nextElement();
                        BlockIfcFigure ifcFigure = logoDrawing.getBlockIfcFigure(connector);
                        if (ifcFigure == null) continue;
                        selectionPainter.remove(ifcFigure);
                    }
                }
                ifcFigures = ((BlockFigure)figure).getOutputIfcFigures();
                for (BlockIfcFigure element : ifcFigures) {
                    selectionPainter.remove(element);
                    for (ConnectionLineConstraint connectionConstraint : ((ConnectorConstraint)element.getConstraint()).getConnectionLineConstraints()) {
                        selectionPainter.remove((PolyLineFigure)connectionConstraint.getFigure());
                    }
                }
                this.markerReferedFigure((BlockFigure)figure, 0);
            } else if (figure instanceof PolyLineFigure) {
                this.getSelectionPainter().remove((PolyLineFigure)figure);
            }
        }
    }

    public void setSelectionMarking(boolean selectionMarking) {
        this.fSelectionMarking = selectionMarking;
        this.clearAllSelectionMarker();
        if (selectionMarking) {
            FigureEnumeration figures = this.selectionElements();
            while (figures.hasMoreElements()) {
                Figure figur = (Figure)figures.nextElement();
                this.figureSelected(figur);
            }
            this.getSelectionPainter().getDrawing().checkDamage();
        } else {
            this.getSelectionPainter().removeAll();
            FigureEnumeration figures = this.selectionElements();
            while (figures.hasMoreElements()) {
                Figure figure = (Figure)figures.nextElement();
                if (!(figure instanceof BlockFigure)) continue;
                this.markerReferedFigure((BlockFigure)figure, 0);
            }
        }
    }

    private void markerReferedFigure(BlockFigure figure, int color) {
        Block selBlock = figure.getBlock();
        Vector allBlocks = ((LogoDrawing)this.drawing()).getWiringDiagram().getBlocks();
        for (int i = 0; i < allBlocks.size(); ++i) {
            Block each = (Block)allBlocks.get(i);
            if (each == selBlock || each.getParameter() == null) continue;
            ParameterItemList items = each.getParameter().getParameterItems();
            for (int j = 0; j < items.size(); ++j) {
                BlockFigure eachFigure;
                Block referBlk;
                Object paramValue = ((ParameterItem)items.get(j)).getInstanceForParameter(each.getParameter()).getValue();
                if (!(paramValue instanceof ValueOrItemReference) || !((ValueOrItemReference)paramValue).isReference() || (referBlk = ((ValueOrItemReference)paramValue).getReference().getParameter().getBlock()) != selBlock || (eachFigure = ((LogoDrawing)this.drawing()).getBlockFigure(each)) == null) continue;
                eachFigure.setToBeReplaced(color);
            }
        }
        this.checkDamage();
    }

    private void clearAllSelectionMarker() {
        FigureEnumeration figures = this.drawing().figures();
        while (figures.hasMoreElements()) {
            Figure figure = (Figure)figures.nextElement();
            if (!(figure instanceof BlockFigure)) continue;
            ((BlockFigure)figure).setToBeReplaced(0);
        }
    }

    protected class MouseWheelZoomer
    implements MouseWheelListener {
        protected MouseWheelZoomer() {
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            if (e.isControlDown()) {
                LogoDrawingView.this.getZoomManager().setZoomAnchor(e.getPoint());
                if (e.getWheelRotation() > 0) {
                    LogoDrawingView.this.getZoomManager().zoomOut();
                } else {
                    LogoDrawingView.this.getZoomManager().zoomIn();
                }
                LogoDrawingView.this.getZoomManager().setZoomAnchor(null);
            } else {
                LogoDrawingView.this.getViewComponent().dispatchEvent(e);
            }
        }
    }

    protected class DrawingDropTargetHandler
    implements DropTargetListener {
        protected LogoAbstractTool fReceivingTool;

        protected DrawingDropTargetHandler() {
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            Tool currentTool = ((LogoComfort)LogoDrawingView.this.getEditor()).tool();
            if (currentTool instanceof LogoAbstractTool && ((LogoAbstractTool)currentTool).acceptDragAndDrop(dropTargetDragEvent)) {
                this.fReceivingTool = (LogoAbstractTool)currentTool;
                this.fReceivingTool.dragEnter(dropTargetDragEvent, LogoDrawingView.this);
            } else {
                DropTarget parentDropTarget = this.getParentDropTarget();
                if (parentDropTarget != null) {
                    parentDropTarget.dragEnter(dropTargetDragEvent);
                }
            }
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            if (this.fReceivingTool != null) {
                this.fReceivingTool.dragExit(dropTargetEvent, LogoDrawingView.this);
                this.fReceivingTool = null;
            } else {
                DropTarget parentDropTarget = this.getParentDropTarget();
                if (parentDropTarget != null) {
                    parentDropTarget.dragExit(dropTargetEvent);
                }
            }
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (this.fReceivingTool != null) {
                this.fReceivingTool.dragOver(dropTargetDragEvent, LogoDrawingView.this);
            } else {
                DropTarget parentDropTarget = this.getParentDropTarget();
                if (parentDropTarget != null) {
                    parentDropTarget.dragOver(dropTargetDragEvent);
                }
            }
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            if (this.fReceivingTool != null) {
                this.fReceivingTool.drop(dropTargetDropEvent, LogoDrawingView.this);
                this.fReceivingTool = null;
            } else {
                DropTarget parentDropTarget = this.getParentDropTarget();
                if (parentDropTarget != null) {
                    parentDropTarget.drop(dropTargetDropEvent);
                }
            }
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
            System.out.println("Drop Action changed!!!");
        }

        private DropTarget getParentDropTarget() {
            Container currentComponent = LogoDrawingView.this;
            for (currentComponent = currentComponent.getParent(); currentComponent != null && currentComponent.getDropTarget() == null; currentComponent = currentComponent.getParent()) {
            }
            if (currentComponent != null) {
                return currentComponent.getDropTarget();
            }
            return null;
        }
    }
}

